﻿//////////////////////////////////////////////
// Static.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "../Enums/Alignment.h"

#include "Component.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>
	
/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT Static : public Component
	{		
		public :
		
			// Constructeur, destructeur
			Static (System* system) noexcept ;
			virtual ~Static () ;

			// Getters
			ALIGNMENT getAlignHorizontal () const ;
			ALIGNMENT getAlignVertical () const ;
			bool getWordWrap () const ;

			// Setters
			virtual void setAlignHorizontal (ALIGNMENT value) ;
			virtual void setAlignVertical (ALIGNMENT value) ;
			virtual void setWordWrap (bool value) ;

			// Import / Export
			virtual void exportIntrospection (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		public :

			// Statics
			static nkMemory::UniquePtr<Static> create (System* system = nullptr) ;

		protected :
		
			// Attributs
			// For styling
			ALIGNMENT _alignHorizontal ;
			ALIGNMENT _alignVertical ;

			bool _wordWrap ;
	} ;
}